<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Sync;

use Alza\Model\MultihubDropShipLogger;
use Core\Model\Entities\EntityManagerDecorator;
use MultihubDropShip\Model\Api\OrderApi;
use MultihubDropShip\Model\Api\ShipmentApi;
use MultihubDropShip\Model\Dao\Client;

class SyncShipment
{
	protected EntityManagerDecorator $em;
	protected ShipmentApi            $shipmentApi;
	protected OrderApi               $orderApi;

	public function __construct(
		EntityManagerDecorator $em,
		ShipmentApi            $shipmentApi,
		OrderApi               $orderApi
	)
	{
		$this->em          = $em;
		$this->shipmentApi = $shipmentApi;
		$this->orderApi    = $orderApi;
	}

	public function setPacking(Client $client, string $dropShipId, int $packagesCount = 1): bool
	{
		return $this->orderApi->setPacking($client, $dropShipId, $packagesCount);
	}

	public function setShipped(Client $client, string $dropShipId): array
	{
		return $this->orderApi->setShipped($client, $dropShipId);
	}

	public function getLabel(Client $client, string $dropShipId): ?string
	{
		return $this->orderApi->getLabel($client, $dropShipId);
	}
}
