<?php declare(strict_types = 1);

namespace MultihubDropShip\AdminModule\Model;

use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Entities\EntityRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Query\Parameter;
use EshopCatalog\Model\Entities\Category;
use Exception;
use MultihubDropShip\Model\Entities\AllowedCategory;
use MultihubDropShip\Model\Entities\Client;

class AllowedCategories
{
	protected ?EntityRepository $er = null;

	public function __construct(
		protected EntityManagerDecorator $em,
	)
	{
	}

	public function getEr(): EntityRepository
	{
		if ($this->er === null) {
			$this->er = $this->em->getRepository(AllowedCategory::class);
		}

		return $this->er;
	}

	/** @param int[] $categories */
	public function updateAllowedCategories(Client $client, array $categories, int $sendAll): bool
	{
		$client->sendAll = $sendAll;
		$this->em->persist($client);
		$this->em->flush();

		$currentCategories = [];

		foreach ($this->getEr()->createQueryBuilder('ac')
			         ->select('IDENTITY(ac.category) as catId')
			         ->where('ac.client = :client')
			         ->setParameters(new ArrayCollection([new Parameter('client', $client)]))->getQuery()->getArrayResult() as $row) {
			/** @var array $row */
			$currentCategories[] = $row['catId'];
		}

		try {
			// Delete
			$delete = array_diff($currentCategories, $categories);
			if ($delete !== []) {
				$this->getEr()->createQueryBuilder('ac')
					->delete()
					->where('ac.category IN (:cats)')
					->andWhere('ac.client = :client')
					->setParameters(new ArrayCollection([new Parameter('cats', $delete), new Parameter('client', $client)]))->getQuery()->execute();
			}

			// Add
			foreach (array_diff($categories, $currentCategories) as $id) {
				/** @var Category $category */
				$category = $this->em->getRepository(Category::class)->find($id);

				$entity = new AllowedCategory($client, $category);
				$this->em->persist($entity);

				$client->allowedCategories->set($id, $entity);
			}

			$this->em->flush();

			return true;
		} catch (Exception $e) {
		}

		return false;
	}
}
