<?php declare(strict_types = 1);

namespace MultihubDropShip\Console;

use Doctrine;
use Exception;
use MultihubDropShip\Model\Sync\SyncCategories;
use Override;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Tracy\Debugger;

#[AsCommand(name: 'multihub-drop-ship:update-all-categories')]
class UpdateCategories extends Command
{
	public function __construct(
		protected SyncCategories $syncCategories,
	)
	{
		parent::__construct();
	}

	#[Override]
	protected function configure(): void
	{
		$this->setName('multihub-drop-ship:update-all-categories')
			->addOption('clientId', null, InputOption::VALUE_REQUIRED)
			->setDescription('Update all categories');
	}

	#[Override]
	protected function execute(
		InputInterface  $input,
		OutputInterface $output,
	): int
	{
		set_time_limit(60 * 30);

		$output->writeln('Multihub DropShip - update all categories');

		try {
			Debugger::dispatch();
			ini_set('memory_limit', '2G');

			$clientId = is_numeric($input->getOption('clientId')) ? (int) $input->getOption('clientId') : null;
			if (!$clientId) {
				throw new Exception('Client not found');
			}

			$this->syncCategories->updateAll($clientId);

			$output->writeLn('<info>[OK] - categories updated</info>');

			return 0;
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
