<?php declare(strict_types = 1);

namespace MultihubDropShip\DI;

use Core\DI\CompilerExtension;
use Nette\PhpGenerator\ClassType;
use Override;

class MultihubDropShipExtension extends CompilerExtension
{
	#[Override]
	public function loadConfiguration(): void
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	#[Override]
	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['MultihubDropShip' => 'MultihubDropShip\*Module\Presenters\*Presenter']);
	}

	#[Override]
	public function afterCompile(ClassType $class): void
	{
		parent::afterCompile($class);
		$init    = $class->getMethod('initialize');
		$builder = $this->getContainerBuilder();

		$init->addBody('MultihubDropShip\Model\MultihubDropShipConfig::setParams(?);', [$builder->parameters['multihubDropShip']]);
	}
}
