<?php declare(strict_types = 1);

namespace MultihubDropShip\FrontModule\Model;

use Core\Model\Entities\EntityManagerDecorator;
use MultihubDropShip\Model\CacheService;
use Nette\Caching\Cache;
use Nette\Utils\Json;

class ReviewsService
{
	public function __construct(
		protected EntityManagerDecorator $em,
		protected CacheService           $cacheService,
	)
	{
	}

	public function getRating(int $id): ?array
	{
		$result = $this->cacheService->getCache()->load($this->cacheService->getRatingKey($id), function(&$dep) use ($id) {
			$dep = [
				Cache::Expire => '1 week',
			];

			$result = [];
			/** @var array $data */
			$data = $this->em->getConnection()->fetchAssociative("SELECT allegro_rating FROM multihub_drop_ship__client WHERE id = ? LIMIT 1", [$id]);

			if (isset($data['allegro_rating'])) {
				try {
					/** @var array $tmp */
					$tmp               = Json::decode((string) $data['allegro_rating'], forceArrays: true) ?: [];
					$result['allegro'] = [
						'rating'        => (float) $tmp['percentage'],
						'reviews_count' => (int) $tmp['count'],
					];
				} catch (\Exception $e) {
				}
			}

			return $result;
		});

		return $result ? (array) $result : null;
	}
}
