<?php declare(strict_types = 1);

namespace MultihubDropShip\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20230623141442 extends AbstractMigration
{
	#[Override]
	public function getDescription(): string
	{
		return '';
	}

	#[Override]
	public function up(Schema $schema): void
	{
		$this->addSql('CREATE TABLE multihub_drop_ship__client (id INT UNSIGNED AUTO_INCREMENT NOT NULL, name VARCHAR(255) NOT NULL, api_key VARCHAR(255) DEFAULT NULL, is_test SMALLINT UNSIGNED DEFAULT 0 NOT NULL, is_active SMALLINT UNSIGNED DEFAULT 0 NOT NULL, image_base_url VARCHAR(255) DEFAULT \'\' NOT NULL, UNIQUE INDEX UNIQ_E6A6E1C35E237E06 (name), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('CREATE TABLE multihub_drop_ship__client_allowed_category (client_id INT UNSIGNED NOT NULL, category_id INT NOT NULL, INDEX IDX_51BB544B19EB6921 (client_id), INDEX IDX_51BB544B12469DE2 (category_id), PRIMARY KEY(client_id, category_id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE multihub_drop_ship__client_allowed_category ADD CONSTRAINT FK_51BB544B19EB6921 FOREIGN KEY (client_id) REFERENCES multihub_drop_ship__client (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE multihub_drop_ship__client_allowed_category ADD CONSTRAINT FK_51BB544B12469DE2 FOREIGN KEY (category_id) REFERENCES eshop_catalog__category (id) ON DELETE CASCADE');
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('ALTER TABLE multihub_drop_ship__client_allowed_category DROP FOREIGN KEY FK_51BB544B19EB6921');
		$this->addSql('DROP TABLE multihub_drop_ship__client');
		$this->addSql('DROP TABLE multihub_drop_ship__client_allowed_category');
	}
}
