<?php declare(strict_types = 1);

namespace MultihubDropShip\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Override;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20230807204809 extends AbstractMigration
{
	#[Override]
	public function getDescription(): string
	{
		return '';
	}

	#[Override]
	public function up(Schema $schema): void
	{
		$this->addSql('CREATE TABLE multihub_drop_ship__order (order_id INT NOT NULL, client_id INT UNSIGNED DEFAULT NULL, drop_ship_id VARCHAR(255) NOT NULL, last_status VARCHAR(255) DEFAULT \'new\' NOT NULL, INDEX IDX_A338B0AC19EB6921 (client_id), INDEX dropShipId (drop_ship_id), PRIMARY KEY(order_id)) DEFAULT CHARACTER SET utf8 COLLATE `utf8_unicode_ci` ENGINE = InnoDB');
		$this->addSql('ALTER TABLE multihub_drop_ship__order ADD CONSTRAINT FK_A338B0AC8D9F6D38 FOREIGN KEY (order_id) REFERENCES eshop_orders__order (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE multihub_drop_ship__order ADD CONSTRAINT FK_A338B0AC19EB6921 FOREIGN KEY (client_id) REFERENCES multihub_drop_ship__client (id) ON DELETE SET NULL');
		$this->addSql('ALTER TABLE multihub_drop_ship__client ADD seller_id INT DEFAULT NULL');
		$this->addSql('ALTER TABLE multihub_drop_ship__client ADD CONSTRAINT FK_E6A6E1C38DE820D9 FOREIGN KEY (seller_id) REFERENCES eshop_catalog__seller (id) ON DELETE SET NULL');
		$this->addSql('CREATE INDEX IDX_E6A6E1C38DE820D9 ON multihub_drop_ship__client (seller_id)');
	}

	#[Override]
	public function down(Schema $schema): void
	{
		$this->addSql('DROP TABLE multihub_drop_ship__order');
		$this->addSql('ALTER TABLE multihub_drop_ship__client DROP FOREIGN KEY FK_E6A6E1C38DE820D9');
		$this->addSql('DROP INDEX IDX_E6A6E1C38DE820D9 ON multihub_drop_ship__client');
		$this->addSql('ALTER TABLE multihub_drop_ship__client DROP seller_id');
	}
}
