<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Api;

use MultihubDropShip\Model\Dao\Category;
use MultihubDropShip\Model\Dao\Client;
use Nette\Utils\Json;

class CategoriesApi extends BaseApi
{
	public function getCategories(Client $client): array
	{
		return $this->sendRequest($client, 'GET', '/api/v1/categories')['data'] ?? [];
	}

	public function updateCategory(Client $client, Category $category): ?array
	{
		/** @var array $data */
		$data = Json::decode(Json::encode($category), Json::FORCE_ARRAY);

		return $this->sendRequest($client, 'POST', '/api/' . $client->updateCategoryV . '/categories', [], $data);
	}

	public function deleteCategory(Client $client, string $id): ?array
	{
		return $this->sendRequest($client, 'DELETE', '/api/' . $client->updateCategoryV . '/categories/' . $id);
	}
}
