<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Api;

use MultihubDropShip\Model\Dao\Client;

class OrderApi extends BaseApi
{
	public function getNewOrders(Client $client): array
	{
		$result = $this->sendRequest($client, 'GET', '/api/v1/orders/new');

		return $result['data'] ?? [];
	}

	public function getCancelled(Client $client): array
	{
		$result = $this->sendRequest($client, 'GET', '/api/v1/orders/cancelled');

		return $result['data'] ?? [];
	}

	public function getDetail(Client $client, string $orderId): ?array
	{
		$result = $this->sendRequest($client, 'GET', '/api/v1/orders/' . $orderId . '/detail');

		return isset($result['data']) ? $result['data']['result'] : null;
	}

	public function setAccepted(Client $client, string $orderId): bool
	{
		$result = $this->sendRequest($client, 'POST', '/api/v1/orders/' . $orderId . '/accepted');

		return $result['data']['result'] ?? false;
	}

	public function setProcessing(Client $client, string $orderId): bool
	{
		$result = $this->sendRequest($client, 'POST', '/api/v1/orders/' . $orderId . '/processing');

		return $result['data']['result'] ?? false;
	}

	public function setPacking(Client $client, string $orderId, int $packagesCount = 1): bool
	{
		$result = $this->sendRequest($client, 'POST', '/api/v1/orders/' . $orderId . '/packing', [], [
			'packagesCount' => $packagesCount,
		]);

		return $result['data']['result'] ?? false;
	}

	public function setShipped(Client $client, string $orderId): array
	{
		$result = $this->sendRequest($client, 'POST', '/api/v1/orders/' . $orderId . '/shipped');

		return $result['data'] ?? [];
	}

	public function setCompleted(Client $client, string $orderId): bool
	{
		$result = $this->sendRequest($client, 'POST', '/api/v1/orders/' . $orderId . '/completed');

		return $result['data']['result'] ?? false;
	}

	public function setCancelled(Client $client, string $orderId): bool
	{
		$result = $this->sendRequest($client, 'POST', '/api/v1/orders/' . $orderId . '/cancelled');

		return $result['data']['result'] ?? false;
	}

	public function addTrackingCode(Client $client, string $orderId, string $trackingNumber): bool
	{
		$result = $this->sendRequest($client, 'POST', '/api/v1/orders/' . $orderId . '/tracking', [], [
			'trackingNumber' => $trackingNumber,
		]);

		return $result['data']['result'] ?? false;
	}

	public function getLabel(Client $client, string $orderId): ?string
	{
		$result = $this->sendRequest($client, 'GET', '/api/v1/orders/' . $orderId . '/label');

		return isset($result['data']) ? $result['data']['result'] : null;
	}

	public function uploadInvoice(Client $client, string $orderId, string $invoiceId, string $fileContent): bool
	{
		$result = $this->sendRequest($client, 'POST', '/api/v1/orders/' . $orderId . '/invoice/', [], [
			'invoiceNumber' => $invoiceId,
			'fileContent'   => base64_encode($fileContent),
		]);

		return $result['data']['result'] ?? false;
	}
}
