<?php declare(strict_types = 1);

namespace MultihubDropShip\Model;

use Nette\Caching\Cache;
use Nette\Caching\Storage;

class CacheService
{
	public Cache $defaultCache;

	public function __construct(
		Storage $cacheStorage
	)
	{
		$this->defaultCache = new Cache($cacheStorage, 'multihubDropShip');
	}

	public function getCache(): Cache
	{
		return $this->defaultCache;
	}

	public function getRatingKey(int $id): string
	{
		return 'rating:' . $id;
	}

	public function clearRating(int $id): void
	{
		$this->getCache()->remove($this->getRatingKey($id));
	}
}
