<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Dao;

class Product
{
	public int $quantity = 0;

	public ?string       $groupId            = null;
	public ?array        $variantFeatureDiff = null;
	public ?string       $variantGroupName   = null;
	public ?ProductImage $variantImage       = null;
	public ?string       $code1              = null;
	public ?string       $code2              = null;
	public ?string       $ean                = null;
	public ?string       $brand              = null;
	public bool          $freeDelivery       = false;
	public ?int          $width              = null;
	public ?int          $height             = null;
	public ?int          $depth              = null;
	public ?int          $weight             = null;
	public string        $condition          = 'new';

	public ?array $categoryHierarchy        = null;
	public ?array $otherCategoriesHierarchy = null;

	/** @var ProductText[] */
	public array $texts = [];

	/** @var ProductImage[] */
	public array $images = [];

	/** @var ProductImagesList[] */
	public array $imagesLists = [];

	/** @var ProductFeature[] */
	public array $features = [];

	/** @var ProductPrice[] */
	public array $prices = [];

	/** @var ProductPriceGroup[] */
	public array $priceLevels = [];

	public function __construct(
		public string          $remoteId,
		int                    $quantity,
		public string          $state,
		public string          $packageSize,
		public ProductCategory $category,
	)
	{
		$this->setQuantity($quantity);
	}

	public function setQuantity(int $quantity): void
	{
		if ($quantity < 0) {
			$quantity = 0;
		}

		$this->quantity = $quantity;
	}
}
