<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\Model\Entities\Category;

#[ORM\Table(name: 'multihub_drop_ship__client_allowed_category')]
#[ORM\Entity]
class AllowedCategory
{
	#[ORM\JoinColumn(referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Client::class, inversedBy: 'allowedCategories')]
	protected Client $client;

	#[ORM\JoinColumn(referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Category::class)]
	protected Category $category;

	public function __construct(Client $client, Category $category)
	{
		$this->client   = $client;
		$this->category = $category;
	}
}
