<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;

#[ORM\Table(name: 'multihub_drop_ship__category_update_list')]
#[ORM\Entity]
class CategoryUpdateList
{
	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	public string $categoryId;

	#[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: false, options: ['default' => 'CURRENT_TIMESTAMP'])]
	public ?\DateTime $created;

	public function __construct(string $categoryId)
	{
		$this->categoryId = $categoryId;
		$this->created    = new DateTime();
	}
}
