<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use EshopOrders\Model\Entities\Order;

#[ORM\Table(name: 'multihub_drop_ship__order')]
#[ORM\Index(columns: ['drop_ship_id'], name: 'dropShipId')]
#[ORM\Entity]
class DropShipOrder
{
	public const StatusNew        = 'new';
	public const StatusAccepted   = 'accepted';
	public const StatusProcessing = 'processing';
	public const StatusPacking    = 'packing';
	public const StatusShipped    = 'shipped';
	public const StatusSent       = 'sent';
	public const StatusCompleted  = 'completed';
	public const StatusCancelled  = 'cancelled';

	#[ORM\JoinColumn(referencedColumnName: 'id', onDelete: 'CASCADE')]
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Order::class)]
	public Order $order;

	#[ORM\JoinColumn(referencedColumnName: 'id', onDelete: 'SET NULL')]
	#[ORM\ManyToOne(targetEntity: Client::class)]
	public Client $client;

	#[ORM\Column(type: Types::STRING, nullable: false)]
	public string $dropShipId;

	#[ORM\Column(type: Types::STRING, nullable: true)]
	public ?string $marketplace = null;

	#[ORM\Column(type: Types::STRING, nullable: false, options: ['default' => 'new'])]
	public string $lastStatus = self::StatusNew;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $trackingNumber = null;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $trackingUrl = null;

	#[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: true)]
	protected ?\DateTime $exported = null;

	public function __construct(Client $client, Order $order, string $dropShipId)
	{
		$this->client     = $client;
		$this->order      = $order;
		$this->dropShipId = $dropShipId;
	}

	public function setExported(): void
	{
		$this->lastStatus = self::StatusShipped;
		$this->exported   = new \DateTime();
	}

	public function getExported(): ?\DateTime { return $this->exported; }
}
