<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'multihub_drop_ship__product_update_list')]
#[ORM\Entity]
class ProductUpdateList
{
	#[ORM\Id]
	#[ORM\Column(type: Types::INTEGER, nullable: false, options: ['unsigned' => true])]
	public int $productId;

	#[ORM\Column(type: Types::DATETIME_MUTABLE, nullable: false, options: ['default' => 'CURRENT_TIMESTAMP'])]
	public ?\DateTime $created;

	public function __construct(int $productId)
	{
		$this->productId = $productId;
		$this->created   = new \DateTime();
	}
}
