<?php declare(strict_types = 1);

namespace MultihubDropShip\Model;

use Nette\Utils\DateTime;
use Nette\Utils\FileSystem;
use Tracy\Debugger;

class MultihubDropShipLogger
{
	protected const logFolder = 'multihubdropship';

	public static function log(mixed $e, ?string $country = null): void
	{
		FileSystem::createDir(LOG_DIR . DS . self::logFolder);
		Debugger::log($e, self::logFolder . '/' . (new DateTime)->format('Y-m-d') . ($country ? '-' . $country : ''));
	}

	public static function logOrder(mixed $e, string $type, ?string $country = null): void
	{
		FileSystem::createDir(LOG_DIR . DS . self::logFolder . DS . 'order');
		Debugger::log($e, self::logFolder . DS . 'order' . DS . $type . '-' . (new DateTime)->format('Y-m-d') . ($country ? '-' . $country : ''));
	}

	public static function logResponse(array $response, ?string $country = null): void
	{
		FileSystem::createDir(LOG_DIR . DS . self::logFolder);

		$msg = $response['date'];
		if (isset($response['errorCodes'])) {
			$msg = $response['errorCodes'];
		} else if (isset($response['result']['message'])) {
			$msg = $response['result']['message'];
		}

		Debugger::log($msg, self::logFolder . '/' . (new DateTime)->format('Y-m-d') . ($country ? '-' . $country : ''));
	}

}
