<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Subscribers;

use Contributte\Events\Extra\Event\Application\ResponseEvent;
use Contributte\Events\Extra\Event\Application\ShutdownEvent;
use Core\Model\Application\AppState;
use Core\Model\Entities\EntityManagerDecorator;
use Core\Model\Event\Event;
use DateTime;
use Exception;
use MultihubDropShip\Model\Clients;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class ApplicationSubscriber implements EventSubscriberInterface
{
	public function __construct(
		protected EntityManagerDecorator $em,
		protected Clients                $clients,
	)
	{
	}

	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [
			ShutdownEvent::class                => 'shutdown',
			ResponseEvent::class                => 'response',
			'cli.eshopCatalog.category.updated' => 'categoryUpdated',
			'cli.dynamicModule.member.updated'  => 'memberUpdated',
		];
	}

	public function shutdown(ShutdownEvent $event): void
	{
		if (ProductSubscriber::$update !== []) {
			$activeClients = $this->clients->getClients();

			if ($activeClients !== []) {
				foreach (array_unique(ProductSubscriber::$update) as $id) {
					try {
						$this->em->getConnection()->executeQuery("INSERT IGNORE INTO multihub_drop_ship__product_update_list (`product_id`, `created`) VALUES (:id, :created)", [
							'id'      => $id,
							'created' => (new DateTime())->format('Y-m-d H:i:s'),
						]);
					} catch (Exception $e) {
					}
				}
			}
		}

		$appStateCategories = AppState::getUpdatedEntitiesIds('eshopCatalog.category');
		if ($appStateCategories) {
			CategorySubscriber::$update = array_merge(CategorySubscriber::$update, $appStateCategories);
		}

		$appStateMembers = AppState::getUpdatedEntitiesIds('dynamicModule.member');
		if ($appStateMembers) {
			CategorySubscriber::$update = array_merge(CategorySubscriber::$update, $appStateMembers);
		}

		if (!empty(CategorySubscriber::$update)) {
			$activeClients = $this->clients->getClients();

			if (!empty($activeClients)) {
				foreach (array_unique(CategorySubscriber::$update) as $id) {
					try {
						$this->em->getConnection()->executeQuery("INSERT IGNORE INTO multihub_drop_ship__category_update_list (`category_id`, `created`) VALUES (:id, :created)", [
							'id'      => (string) $id,
							'created' => (new DateTime())->format('Y-m-d H:i:s'),
						]);
					} catch (\Exception $e) {
					}
				}
			}
		}
	}

	public function categoryUpdated(Event $data): void
	{
		$categories = $data->data['categories'] ?? [];
		if (!empty($categories)) {
			$activeClients = $this->clients->getClients();

			if (!empty($activeClients)) {
				foreach (array_unique($categories) as $id) {
					try {
						$this->em->getConnection()->executeQuery("INSERT IGNORE INTO multihub_drop_ship__category_update_list (`category_id`, `created`) VALUES (:id, :created)", [
							'id'      => (string) $id,
							'created' => (new DateTime())->format('Y-m-d H:i:s'),
						]);
					} catch (\Exception $e) {
					}
				}
			}
		}
	}

	public function memberUpdated(Event $data): void
	{
		$members = $data->data['members'] ?? [];
		if (!empty($members)) {
			$activeClients = $this->clients->getClients();

			if (!empty($activeClients)) {
				foreach (array_unique($members) as $id) {
					try {
						$this->em->getConnection()->executeQuery("INSERT IGNORE INTO multihub_drop_ship__category_update_list (`category_id`, `created`) VALUES (:id, :created)", [
							'id'      => 'V_' . $id,
							'created' => (new DateTime())->format('Y-m-d H:i:s'),
						]);
					} catch (\Exception $e) {
					}
				}
			}
		}
	}

	public function response(ResponseEvent $event): void
	{
	}
}
