<?php declare(strict_types = 1);

namespace MultihubDropShip\Model\Sync;

use Core\Model\Sites;
use EshopCatalog\AdminModule\Model\Categories;
use MultihubDropShip\Model\Api\CategoriesApi;
use MultihubDropShip\Model\CategoryBuilder;
use MultihubDropShip\Model\Clients;
use MultihubDropShip\Model\Dao\Client;
use MultihubDropShip\Model\EshopCategories;

class SyncCategories
{
	public function __construct(
		protected Clients         $clients,
		protected CategoriesApi   $categoriesApi,
		protected Categories      $categories,
		protected EshopCategories $eshopCategories,
		protected CategoryBuilder $categoryBuilder,
	)
	{
	}

	public function updateAll(int $clientId): void
	{
		$client = $this->clients->getClient($clientId);
		if (!$client instanceof Client) {
			return;
		}

		Sites::$currentIdentOverride = $client->siteIdent;
		Sites::$currentLangOverride  = $client->lang;

		$categoriesIds = $this->eshopCategories->getCategories($client);

		if ($categoriesIds === []) {
			return;
		}

		$hubCategories = $this->categoriesApi->getCategories($client);

		foreach (array_keys(array_diff_key($hubCategories, array_flip($categoriesIds))) as $id) {
			$this->categoriesApi->deleteCategory($client, (string) $id);
		}

		foreach ($this->categoryBuilder->buildCategories($client, $categoriesIds) as $category) {
			$this->categoriesApi->updateCategory($client, $category);
		}
	}
}
