<?php declare(strict_types = 1);

namespace MyGls\DI;

use Core\DI\CompilerExtension;
use Nette\PhpGenerator\ClassType;
use Nette\Utils\FileSystem;
use Override;

class MyGlsExtension extends CompilerExtension
{

	#[Override]
	public function loadConfiguration(): void
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	#[Override]
	public function beforeCompile(): void
	{
		parent::beforeCompile();
		FileSystem::createDir(DATA_DIR . '/MyGls/labels');
		$this->setMapping(['MyGls' => 'MyGls\*Module\Presenters\*Presenter']);
	}

	#[Override]
	public function afterCompile(ClassType $class): void
	{
		parent::afterCompile($class);
		$init = $class->getMethod('initialize');

		$init->addBody('MyGls\Model\MyGlsConfig::setParams($this->parameters[\'myGls\']);');
		$init->addBody('define("MYGLS_DIR", DATA_DIR . "/MyGls");');
	}
}
