<?php declare(strict_types = 1);

namespace MyGls\Model\Subscribers;

use EshopOrders\Model\Event\EmailEvent;
use EshopOrders\Model\Helpers\OrderHelper;
use MyGls\Model\OrdersExported;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class OrderEmailSubscriber implements EventSubscriberInterface
{
	public function __construct(
		protected OrdersExported $ordersExported,
	)
	{
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.emailChangeOrderStatus' => 'emailChangeOrderStatus',
		];
	}

	public function emailChangeOrderStatus(EmailEvent $event): void
	{
		if (!$event->status || !OrderHelper::canSendTrackingUrl($event->status) || !$event->order->getId()) {
			return;
		}

		$exported = $this->ordersExported->getOrdersExported([$event->order->getId()])[$event->order->getId()] ?? null;

		if ($exported && $exported->numberPackage) {
			$event->template->trackingUrl    = $exported->getTrackingUrl();
			$event->template->trackingNumber = $exported->numberPackage;
		}
	}
}
