document.addEventListener('click', e => {
	const target = e.target;

	if (target.dataset.myglsPickupTrigger !== undefined) {
		const popup = document.createElement('div');
		popup.setAttribute('data-input', target.id);
		popup.setAttribute('id', 'myGlsIframePopup');
		popup.setAttribute('style', 'z-index: 999999; position: fixed; -webkit-backface-visibility: hidden; left: 0; top: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.3);');

		const wrap = document.createElement('div');
		wrap.setAttribute('style', 'position: absolute; left: 0px; top: 0px; width: 100%; height: 100svh; padding: 1rem .7rem; display: flex; flex-direction: column;');

		const head = document.createElement('div');
		head.setAttribute('style', 'text-align: right; padding: 1rem; height: 4rem');
		head.classList.add('primary-bg-color');

		const close = document.createElement('a');
		close.setAttribute('href', 'javascript:;');
		close.setAttribute('style', 'cursor: pointer; display: inline-block;');
		close.innerHTML = '<i style="fill: #fff; width: 2rem; height: 2rem;" data-svg-icon-pshk="close"></i>';
		close.addEventListener('click', e => {
			popup.remove();
		});

		head.appendChild(close);
		wrap.appendChild(head);

		const iframe = document.createElement('iframe');
		iframe.setAttribute('style', 'background: white; border: hidden; width: 100%; flex: 1;');

		const url = new URL('https://maps.gls-czech.cz');
		url.searchParams.set('find', '1');
		url.searchParams.set('ctrcode', target.dataset.country.toUpperCase());

		if (target.dataset.myglsDisabled) {
			let disabled = target.dataset.myglsDisabled.split(',');
			disabled.forEach(code => {
				url.searchParams.append('nogroup[]', code);
			});
		}

		iframe.setAttribute('src', url.toString());
		wrap.appendChild(iframe);

		popup.appendChild(wrap);

		document.body.appendChild(popup);

		document.dispatchEvent(new Event('loadSvgIcons'));
	}
});

window.addEventListener('message', e => {
	const ps = e.data.parcelshop;

	if (ps === undefined || !ps.detail || !ps.detail.pclshopid)
		return;

	const iframePopup = document.getElementById('myGlsIframePopup');
	if (!iframePopup)
		return;

	const inputPlaceholder = document.getElementById(iframePopup.dataset.input);
	inputPlaceholder.value = ps.detail.name + ' - ' + ps.detail.address + ' ' + ps.detail.city;

	const inputTarget = document.getElementById(inputPlaceholder.dataset.myglsPickupTrigger);
	inputTarget.value = ps.detail.pclshopid;
	const inputStreet = document.getElementById(inputPlaceholder.dataset.street);
	inputStreet.value = ps.detail.address;
	const inputCity   = document.getElementById(inputPlaceholder.dataset.city);
	inputCity.value   = ps.detail.city;
	const inputPostal = document.getElementById(inputPlaceholder.dataset.postal);
	inputPostal.value = ps.detail.zipcode;

	let ev = new CustomEvent('pickup-changed', {
		detail: {
			expedition: 'gls'
		}
	});

	window.dispatchEvent(ev);

	iframePopup.remove();
});
