<?php declare(strict_types = 1);

namespace MyGls\DI;

use Core\DI\CompilerExtension;
use Nette;
use Nette\Utils\FileSystem;

class MyGlsExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		FileSystem::createDir(DATA_DIR . '/MyGls/labels');
		$this->setMapping(['MyGls' => 'MyGls\*Module\Presenters\*Presenter']);
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init = $class->methods["initialize"];

		$init->addBody('MyGls\Model\MyGlsConfig::setParams($this->parameters[\'myGls\']);');
		$init->addBody('define("MYGLS_DIR", DATA_DIR . "/MyGls");');
	}
}
