<?php declare(strict_types=1);

namespace MyGls\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="my_gls__parcel_number")
 * @ORM\Entity
 */
class GlsParcelNumber
{
	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", nullable=false)
	 */
	public string $numberPackage;

	/**
	 * @ORM\ManyToOne(targetEntity="GlsOrder", inversedBy="associatedNumberPackages")
	 * @ORM\JoinColumn(name="parcel_order_id", referencedColumnName="order_id", nullable=false, onDelete="CASCADE")
	 */
	protected GlsOrder $parcelOrder;

	public function __construct(string $numberPackage, GlsOrder $parcelOrder)
	{
		$this->numberPackage = $numberPackage;
		$this->parcelOrder = $parcelOrder;
	}

	public function getNumberPackage(): string
	{
		return $this->numberPackage;
	}

}
