<?php declare(strict_types = 1);

namespace Navigations\FrontModule\Components;

use Core\Model\UI\BaseControl;
use Navigations\Model\Navigations;

class LangSwitcher extends BaseControl
{
	/** @var Navigations */
	protected $navigationsService;

	public function __construct(Navigations $navigations)
	{
		$this->navigationsService = $navigations;
	}

	public function render()
	{
		$links      = [];
		$currentNav = $this->getPresenter()->getActiveNavigation();

		foreach ($this->langsService->getLangs(false) as $lang) {
			$nav                        = $this->navigationsService->getNavigation($currentNav->id, $lang->getTag());
			$params                     = $this->getPresenter()->getParameters();
			$params['activeNavigation'] = $nav;
			$params['presenter']        = $this->getPresenter()->getName();
			$params['locale']           = $lang->getTag();

			$links[$lang->getTag()] = [
				'title'      => $lang->getTitle(),
				'shortTitle' => $lang->getShortTitle(),
				'link'       => $nav
					? $this->navigationsService->getUrlById($params)
					: '/' . ($lang->getTag() !== $this->langsService->getLang()->getTag() ? $lang->getTag() : ''),
				'isActive'   => $this->translator->getLocale() === $lang->getTag() ? true : false,
			];
		}

		$this->template->links = $links;
		$this->template->activeLang = $links[$this->translator->getLocale()];
		$this->template->render($this->getTemplateFile());
	}
}
