<?php declare(strict_types = 1);

namespace Navigations\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Core\Model\UI\Form\BaseContainer;
use Navigations\Model\Navigations;
use Nette\Localization\ITranslator;

class CurrentNavigation extends TemplateTextType implements ITemplateTextType
{

	protected $type = 'navByGroup';

	/** @var Navigations */
	protected $navigationsService;

	/** @var ITranslator */
	protected $translator;

	public function __construct(Navigations $navigations, ITranslator $translator)
	{
		$this->navigationsService = $navigations;
		$this->translator         = $translator;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
		$groups = [null => ''];

		$navigationItems = $this->navigationsService
			->getEr()->createQueryBuilder('n')
			->innerJoin('n.texts', 'nt', 'WITH', 'nt.lang = :lang')
			->setParameter('lang', $this->translator->getLocale())
			->addSelect('nt')
			->getQuery()
			->getResult();
	
		foreach ($navigationItems as $n) {
			$groups[$n->getId()] = $n->texts[$this->translator->getLocale()]->title;
		}

		$formContainer->addSelect($this->getName(), $this->getTitle(), $groups);
	}

	/**
	 * @param $params
	 *
	 * @return mixed
	 */
	public function render($params)
	{
		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		return $this->navigationsService->getNavigation((int) $this->getDefault());
	}
}
