<?php declare(strict_types = 1);

namespace Navigations\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Entities\NavigationGroup;

/**
 * Class NavigationsGroups
 * @package Navigations\Model
 *
 * @method NavigationGroup|object|null getReference($id)
 * @method NavigationGroup[]|null getAll()
 * @method NavigationGroup|null get($id)
 */
class NavigationsGroups extends BaseFrontEntityService
{
	protected $entityClass = NavigationGroup::class;

	/**
	 * @return null|NavigationGroup[]
	 */
	public function getAll() { return $this->getEr()->findAll(); }

	/**
	 * @param $id
	 *
	 * @return null|object|NavigationGroup
	 */
	public function find($id)
	{
		return $this->getEr()->find($id);
	}

	/**
	 * @param $id
	 *
	 * @return \Doctrine\ORM\Proxy\Proxy
	 */
	public function getReference($id)
	{
		return $this->getEr()->getReference($id);
	}
}
