<?php declare(strict_types = 1);

namespace Navigations\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Navigations\Model\Entities\Navigation;

/**
 * Class Navigations
 * @package Navigations\AdminModule\Model
 *
 * @method Navigation|object|null getReference($id)
 * @method Navigation[]|null getAll()
 * @method Navigation|null get($id)
 */
class Navigations extends BaseEntityService
{
	protected $entityClass = Navigation::class;

	/**
	 * @param $id
	 * @param $state
	 *
	 * @return bool
	 * @throws \Exception
	 */
	public function setPublish($id, $state)
	{
		if ($nav = $this->get($id)) {
			$nav->isPublished = $state;
			$this->em->persist($nav);
			$this->em->flush();

			return true;
		}

		return false;
	}

	/**
	 * @param $id
	 *
	 * @return bool
	 * @throws \Exception
	 */
	public function setHomepage($id)
	{
		if ($nav = $this->get($id)) {
			$q = $this->getEr()->createQueryBuilder()->update(Navigation::class, 'n')
				->set('n.isHomepage', '0')
				->where('n.isHomepage != 0');
			if ($nav->getLang())
				$q->andWhere('n.lang = :lang')->setParameter('lang', $nav->getLang());
			else
				$q->andWhere('n.lang IS NULL');
			$q->getQuery()->execute();

			$nav->isHomepage = 1;
			$this->em->persist($nav);
			$this->em->flush();

			return true;
		}

		return false;
	}

	/**
	 * @param $id
	 *
	 * @return bool
	 * @throws \Exception
	 */
	public function removeNavigation($id)
	{
		if ($tag = $this->getEr()->find($id)) {
			$this->em->remove($tag);
			$this->em->flush();

			return true;
		}

		return false;
	}

	/**
	 * @param $id
	 * @param $position
	 *
	 * @return bool
	 * @throws \Exception
	 */
	public function setPosition($id, $position)
	{
		if ($item = $this->getReference($id)) {
			$item->setPosition($position);
			$this->em->persist($item);
			$this->em->flush();

			return true;
		}

		return false;
	}

	/**
	 * @param $alias
	 * @param $locale
	 *
	 * @return Navigation|null|object
	 */
	public function findByAlias($alias, $locale)
	{
		$navigations = $this->getEr()->createQueryBuilder('n')
			->andWhere('n.alias = :alias')->setParameter('alias', $alias);

		if ($locale)
			$navigations->andWhere('n.lang = :locale')->setParameter('locale', $locale);
		else
			$navigations->andWhere('n.lang IS NULL');

		$navigations = $navigations->getQuery()->getResult();

		$navigation = null;

		foreach ($navigations as $v)
			if ($v->lang == $locale) {
				$navigation = $v;
				break;
			}

		if (!$navigation)
			$navigation = array_values($navigations)[0];

		return $navigation;
	}
}
