<?php declare(strict_types = 1);

namespace Navigations\Model\Entities;

use Core\Model\Entities\Redirect;
use Core\AdminModule\Model\Redirects;
use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Events\Subscriber;
use Navigations\Model\Navigations;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\Http\Session;
use Nette\SmartObject;

class NavigationListener implements Subscriber
{
	use SmartObject;

	/** @var Cache */
	private $cache;

	/** @var Session */
	private $session;

	/** @var Redirects */
	protected $redirectsService;

	protected $fields = false;

	public function __construct(IStorage $cacheStorage, Session $session, Redirects $redirects)
	{
		$this->session          = $session;
		$this->cache            = new Cache($cacheStorage, Navigations::CACHE_NAMESPACE);
		$this->redirectsService = $redirects;
	}

	public function getSubscribedEvents()
	{
		return [];
	}

	/**
	 * @ORM\PostPersist
	 * @ORM\PostUpdate
	 * @ORM\PostRemove
	 *
	 * @param Navigation         $navigation
	 * @param LifecycleEventArgs $event
	 */
	public function postHandler(Navigation $navigation, LifecycleEventArgs $event)
	{
		$this->cache->clean([
			Cache::TAGS => [Navigations::CACHE_NAMESPACE],
		]);
	}

	/**
	 * @ORM\PostUpdate
	 *
	 * @param Navigation         $navigation
	 * @param LifecycleEventArgs $event
	 *
	 * @throws Doctrine\ORM\ORMException
	 */
	public function postUpdateHandler(Navigation $navigation, LifecycleEventArgs $event)
	{
		$em        = $event->getEntityManager();
		$changeSet = $em->getUnitOfWork()->getEntityChangeSet($navigation);

		if (isset($changeSet['alias']) && !$navigation->isHomepage) {
			list($from, $to) = $changeSet['alias'];

			$fromExist = $this->redirectsService->getEr()->findOneBy(['from'        => $to, 'package' => 'Navigations',
			                                                          'relationKey' => 'Navigation']);
			if ($fromExist)
				$em->remove($fromExist);

			$toExist = $this->redirectsService->getEr()->findBy(['to'          => $from, 'package' => 'Navigations',
			                                                     'relationKey' => 'Navigation']);
			foreach ($toExist as $red) {
				$red->to = $to;
				$em->persist($red);
			}

			// TODO přesunout do služby?
			$redirect                = new Redirect('Navigation redirect - ' . $from . ' -> ' . $to, $from, $to);
			$redirect->isLocked      = 1;
			$redirect->package       = reset(explode('\\', __NAMESPACE__));
			$redirect->relationKey   = 'Navigation';
			$redirect->relationValue = $navigation->getId();

			$em->persist($redirect);
			$em->flush();
		}
	}
}
