<?php declare(strict_types = 1);

namespace Navigations\Model;

use Core\Model\Helpers\BaseEntityService;
use Navigations\Model\Entities\NavigationGroup;

class NavigationsGroups extends BaseEntityService
{
	protected $entityClass = NavigationGroup::class;

	/**
	 * @return null|NavigationGroup[]
	 */
	public function getAll() { return $this->getEr()->findAll(); }

	/**
	 * @param $id
	 *
	 * @return null|object|NavigationGroup
	 */
	public function find($id)
	{
		return $this->getEr()->find($id);
	}

	/**
	 * @param $id
	 *
	 * @return \Doctrine\ORM\Proxy\Proxy
	 */
	public function getReference($id)
	{
		return $this->getEr()->getReference($id);
	}

	/**
	 * @param $id
	 *
	 * @return bool
	 * @throws \Exception
	 */
	public function removeNavigationGroup($id)
	{
		if ($tag = $this->getEr()->find($id)) {
			$this->em->remove($tag);
			$this->em->flush();

			return true;
		}

		return false;
	}
}