<?php declare(strict_types = 1);

namespace Navigations\Model\Templating\Filters;

use Navigations\Model\Navigations;

class NavLink
{
	/** @var Navigations */
	protected $navigationsService;

	public function __construct(Navigations $navigations)
	{
		$this->navigationsService = $navigations;
	}

	public function __invoke($id)
	{
		$nav = $this->navigationsService->getNavigation($id);

		return $nav ? $this->navigationsService->generateLink($nav) : '';
	}
}
