<?php declare(strict_types = 1);

namespace Navigations\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Entities\NavigationGroup;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;

class NavigationGroupForm extends BaseControl
{
	/** @var NavigationGroup */
	public $navigationGroup;

	public function render()
	{
		$this->template->setFile(__DIR__ . '/NavigationGroupForm.latte');
		$this->template->render();
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();
		$form->setAjax();

		$form->addText('title', 'default.title')->setMaxLength(255)->setRequired();
		$form->addText('type', 'default.type')->setMaxLength(255)->setRequired();
		$form->addSaveCancelControl('saveControl');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			$navigationGroup = $this->navigationGroup ?: new NavigationGroup($values->title);

			$navigationGroup->title = $values->title;
			$navigationGroup->type  = $values->type;

			$flashMessage = $navigationGroup->getId() ? 'navigations.navigationGroupForm.edited' : 'navigations.navigationGroupForm.added';
			$this->em->persist($navigationGroup);
			$this->em->flush();
			$form->addCustomData('navigationGroupId', $navigationGroup->getId());
			$this->getPresenter()->flashMessageSuccess($flashMessage);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	/*******************************************************************************************************************
	 * ===========================  Get/Set
	 */

	public function setNavigationGroup($id)
	{
		$this->navigationGroup = $this->em->getRepository(NavigationGroup::class)->find($id);

		if ($this->navigationGroup) {
			$this['form']->setDefaults([
				'title' => $this->navigationGroup->title,
				'type'  => $this->navigationGroup->type,
			]);
		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}
}
