<?php declare(strict_types = 1);

namespace Navigations\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Navigations\Model\Entities\NavigationGroup;
use Navigations\Model\NavigationsGroups;

class NavigationsGroupsGrid extends BaseControl
{
	/** @var NavigationsGroups */
	protected $navigationsGroupsService;

	public function __construct(NavigationsGroups $navigationsGroups)
	{
		$this->navigationsGroupsService = $navigationsGroups;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();

		$qb = $this->navigationsGroupsService->getEr()->createQueryBuilder('g');
		$grid->setDataSource($qb);

		// Columns
		$grid->addColumnLink('title', 'navigations.navigation.title', 'Default:editGroup');

		// Filter
		$grid->addFilterText('title', 'navigations.navigation.title');

		// Actions
		$grid->addAction('edit', '', 'Default:editGroup')->setIcon('edit')->setBsType('primary');
		$grid->addAction('delete', '', 'delete!')->setIcon('times')->setBsType('danger')->addClass('ajax');


		return $grid;
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		if ($this->navigationsGroupsService->removeNavigationGroup($id))
			$presenter->flashMessageSuccess('default.removed');
		else
			$presenter->flashMessageDanger('default.removeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}
}
