<?php declare(strict_types = 1);

namespace Navigations\DI;

use Core\DI\CompilerExtension;
use Kdyby\Translation\ITranslator;
use Navigations\Model\Navigations;
use Navigations\Model\Providers\INavigationItem;
use Navigations\Model\Templating\Macros\NavLink;
use Nette;

class NavigationsExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		Nette\DI\Compiler::loadDefinitions(
			$this->getContainerBuilder(),
			$this->loadFromFile(__DIR__ . '/services.neon')
		);
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Navigations' => 'Navigations\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();

		$builder->getDefinition('nette.latteFactory')
			->addSetup(NavLink::class . '::install(?->getCompiler(), ?)', ['@self',
				$builder->getDefinition('navigations.navigations')])
			->addSetup('addFilter', ['navLink', $builder->getDefinition('navigations.filters.navLink')]);

		$service = $builder->getDefinition('navigations.itemsCollector');
		$service->addSetup(new Nette\DI\Statement('$service->loadClasses(?)', [$builder->findByType(INavigationItem::class)]));

		foreach ($builder->findByType(INavigationItem::class) as $service)
			$service->addSetup('setTranslator', [$builder->getDefinition($builder->getByType(ITranslator::class))]);
	}
}