<?php declare(strict_types = 1);

namespace Navigations\Model;

use Core\Model\Helpers\BaseService;
use Core\Model\Helpers\Traits\TTranslator;
use Navigations\Model\Providers\INavigationItem;

class ItemsCollector extends BaseService
{
	use TTranslator;

	/** @var array */
	protected $items = [];

	/** @var INavigationItem[] */
	private $itemsList = [];

	/**
	 * ItemsCollector constructor.
	 */
	public function __construct()
	{
	}

	/**
	 * @param $id
	 *
	 * @return INavigationItem|null
	 */
	public function getItemById($id)
	{
		return isset($this->itemsList[$id]) ? $this->itemsList[$id] : null;
	}

	/**
	 * @return array
	 */
	public function getItems()
	{
		return $this->items;
	}

	public function findItemByPresenter($presenter, $action)
	{
		$items = [];
		foreach ($this->itemsList as $item) {
			$r = $item->presenterActionCheck($presenter, $action);
			if ($r)
				$items[$r][] = $item;
		}

		return $items;
	}

	/**
	 * Voláno při generování containeru
	 *
	 * @param $items
	 */
	public function loadClasses($items)
	{
		foreach ($items as $key => $item) {
			/** @var $item BaseItem */
			$item->getGroup();
			$item->setId($key);

			$this->itemsList[$key] = $item;
			$arr                   = &$this->items[$item->getGroup()];

			if (!isset($arr))
				$arr = ['title' => $item->getGroupTitle(), 'items' => []];

			$arr['items'][] = $item;
		}
	}
}