<?php declare(strict_types = 1);

namespace Navigations\Model\Providers;

use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Entities\Navigation;
use Nette\Utils\ArrayHash;

interface INavigationItem
{
	/**
	 * @return string
	 */
	public function getId();

	/**
	 * @return string
	 */
	public function getGroup();

	/**
	 * @return string
	 */
	public function getGroupTitle();

	/**
	 * @return string
	 */
	public function getTitle();

	/**
	 * @return BaseContainer
	 */
	public function getFormContainer();

	public function formSuccess(BaseForm $form, ArrayHash $values);

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	/**
	 * @param $presenter
	 * @param $action
	 *
	 * @return bool
	 */
	public function presenterActionCheck($presenter, $action);

	/**
	 * @return string
	 */
	public function getPresenter();

	/**
	 * @return string
	 */
	public function getAction();

	/**
	 * @param       $componentParams
	 * @param array $urlParams
	 *
	 * @return mixed
	 */
	public function routerIn($componentParams, $urlParams = []);

	/**
	 * @param Navigation $navigation
	 * @param array      $id
	 *
	 * @return bool
	 */
	public function routerOut($navigation, &$id);
}