<?php declare(strict_types = 1);

namespace Navigations\Model\Event;

use Core\Components\Navigation\DaoNavigationItem;
use Symfony\Component\EventDispatcher\Event;

class RouteInEvent extends Event
{
	/** @var DaoNavigationItem */
	public $navigation;

	/** @var array */
	public $urlParams;

	/** @var array */
	public $return;

	/** @var bool */
	public $disableDefaultFilter = false;

	public function __construct(?DaoNavigationItem $navigation, array &$urlParams, array &$return)
	{
		$this->navigation = $navigation;
		$this->urlParams  = &$urlParams;
		$this->return     = &$return;
	}
}
