<?php declare(strict_types = 1);

namespace Navigations\Model\Entities;

use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="navigations__navigation_group")
 * @ORM\Entity
 * @ORM\EntityListeners({"NavigationGroupListener", "Core\Model\Entities\TranslateListener"})
 */
class NavigationGroup
{
	use Identifier;
	use MagicAccessors;
	use TTranslateListener;

	/**
	 * @var NavigationGroupText[]
	 * @ORM\OneToMany(targetEntity="NavigationGroupText", mappedBy="navigationGroup", indexBy="lang")
	 */
	protected $texts;

	/**
	 * @var string
	 * @ORM\Column(name="type", type="string", length=255, nullable=true)
	 */
	public $type;

	public function __construct(string $type)
	{
		$this->type  = $type;
		$this->texts = new ArrayCollection();
	}

	public function setTexts(array $texts): self
	{
		$this->texts = new ArrayCollection($texts);

		return $this;
	}

	public function getText(?string $lang = null): ?NavigationGroupText { return $this->texts[$lang ?: $this->locale] ?? null; }

	/** @return NavigationGroupText[]|ArrayCollection */
	public function getTexts() { return $this->texts; }
}
