<?php declare(strict_types = 1);

namespace Navigations\Model\Event;

use Core\Components\Navigation\DaoNavigationItem;
use Navigations\Model\Entities\Navigation;
use Symfony\Component\EventDispatcher\Event;

class RouteOutEvent extends Event
{
	/** @var Navigation */
	public $navigation;

	/** @var array */
	public $urlParams;

	/** @var string */
	public $url;

	/** @var bool */
	public $disableDefaultFilter = false;

	public function __construct(DaoNavigationItem $navigation, array &$urlParams, string &$url)
	{
		$this->navigation = $navigation;
		$this->urlParams  = &$urlParams;
		$this->url        = &$url;
	}
}
