<?php declare(strict_types = 1);

namespace Navigations\AdminModule\Presenters;

use Core\AdminModule\Presenters\SecuredPresenter;

abstract class BasePresenter extends SecuredPresenter
{
	public function checkRequirements($element): void
	{
		parent::checkRequirements($element);
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'access'))
			$this->error();
	}
}
