<?php declare(strict_types = 1);

namespace Navigations\FrontModule\Components;

use Core\Model\UI\BaseControl;
use Navigations\FrontModule\Model\LinksHelper;

class HrefLang extends BaseControl
{
	protected LinksHelper $linksHelper;

	public function __construct(LinksHelper $linksHelper)
	{
		$this->linksHelper = $linksHelper;
	}

	public function render($args = []): void
	{
		$links = $this->getLinks();

		$this->template->renderArgs = $args;
		$this->template->links      = $links;
		$this->template->activeLang = $links[$this->translator->getLocale()];
		$this->template->render($this->getTemplateFile());
	}

	public function getLinks(): array
	{
		$presenter = $this->getPresenter();

		return $this->linksHelper->getOtherLangLinks($presenter->getActiveNavigation(), $presenter->getParameters(), $presenter->getName());
	}
}
