<?php declare(strict_types = 1);

namespace Navigations\FrontModule\Components;

use Core\Model\Helpers\Strings;
use Core\Model\UI\BaseControl;
use Currency\FrontModule\Components\CurrencySwitch;
use Navigations\FrontModule\Model\LinksHelper;

class LangSwitcher extends BaseControl
{
	public const CURRENCY_MAP = [
		'sk' => 'EUR',
		'cs' => 'CZK',
	];

	protected LinksHelper $linksHelper;

	public function __construct(LinksHelper $linksHelper)
	{
		$this->linksHelper = $linksHelper;
	}

	public function render($args = []): void
	{
		$links = $this->getLinks();

		$this->template->renderArgs = $args;
		$this->template->links      = $links;
		$this->template->activeLang = $links[$this->translator->getLocale()];
		$this->template->render($this->getTemplateFile());
	}

	public function getLinks(): array
	{
		$presenter = $this->getPresenter();
		$links     = [];

		foreach ($this->linksHelper->getOtherLangLinks($presenter->getActiveNavigation(), $presenter->getParameters(), $presenter->getName()) as $lang => $link) {
			/** @var CurrencySwitch $currencySwitch */
			if (class_exists(CurrencySwitch::class)) {
				$currencySwitch = $this->getPresenter()->getComponent('currencySwitch', false);

				if ($currencySwitch && $link) {
					foreach (self::CURRENCY_MAP as $l => $c) {
						if ($lang === $l && isset($currencySwitch->getActiveCurrencies()[$c])) {
							$link['link'] .= (Strings::contains((string) $link['link'], '?') ? '&' : '?') .
								'curr=' . $currencySwitch->getActiveCurrencies()[$c]->getCode();
							break;
						}
					}
				}
			}

			$links[$lang] = $link;
		}

		return $links;
	}
}
