<?php declare(strict_types = 1);

namespace Navigations\FrontModule\Model;

use Core\Model\Lang\Langs;
use Nette\Localization\Translator;
use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\Sites;
use Navigations\Model\Navigations;

class LinksHelper
{
	protected Sites $sites;

	protected Navigations $navigations;

	protected Translator $translator;

	protected Langs $langs;

	protected ?array $cLinks = null;

	public function __construct(Sites $sites, Navigations $navigations, Translator $translator, Langs $langs)
	{
		$this->sites       = $sites;
		$this->navigations = $navigations;
		$this->translator  = $translator;
		$this->langs       = $langs;
	}

	/**
	 * @param DaoNavigationItem $currentNav
	 * @param array             $currentParams
	 * @param string            $presenterName
	 *
	 * @return array
	 */
	public function getOtherLangLinks($currentNav, array $currentParams, string $presenterName): array
	{
		if ($currentNav instanceof DaoNavigationItem === false)
			return [];

		if ($this->cLinks !== null)
			return $this->cLinks;

		$this->cLinks = [];
		$currentSite  = $this->sites->getCurrentSite();
		$defaultLang  = $this->translator->getDefaultLocale();

		foreach ($this->translator->getLocalesWhitelist() as $lang) {
			$siteDomain = $currentSite->getDomains()[$lang];
			$domain     = $siteDomain && $siteDomain->getDomain() ? $siteDomain->getDomain() : null;
			$langData   = $this->langs->getLang($lang);

			if (!$domain)
				continue;

			$nav                        = $this->navigations->getNavigation($currentNav->id, $lang);
			$params                     = $currentParams;
			$params['activeNavigation'] = $nav;
			$params['presenter']        = $presenterName;
			$params['locale']           = $lang;
			$params['domain']           = $domain;

			$link = $nav
				? $this->navigations->getUrlById($params)
				: 'https://' . $domain . '/' . ($siteDomain->isDefault == 0 && $lang !== $defaultLang ? $lang : '');

			$this->cLinks[$lang] = [
				'title'      => $langData->getTitle(),
				'shortTitle' => $langData->getShortTitle(),
				'link'       => $link,
				'isActive'   => $this->translator->getLocale() === $lang ? true : false,
				'navigation' => $nav,
			];
		}

		return $this->cLinks;
	}
}
