<?php declare(strict_types = 1);

namespace Navigations\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Navigations\Model\Navigations;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\Http\Session;
use Nette\SmartObject;

class NavigationListener implements EventSubscriberInterface
{
	use SmartObject;

	/** @var Cache */
	private $cache;

	/** @var Cache */
	private $baseCache;

	/** @var Session */
	private $session;

	protected $fields = false;

	public function __construct(IStorage $cacheStorage, Session $session)
	{
		$this->session   = $session;
		$this->cache     = new Cache($cacheStorage, Navigations::CACHE_NAMESPACE);
		$this->baseCache = new Cache($cacheStorage, 'base');
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PostPersist
	 * @ORM\PostUpdate
	 * @ORM\PostRemove
	 *
	 * @param Navigation         $navigation
	 * @param LifecycleEventArgs $event
	 */
	public function postHandler(Navigation $navigation, LifecycleEventArgs $event)
	{
		$this->cache->clean([
			Cache::TAGS => [Navigations::CACHE_NAMESPACE],
		]);
		$this->baseCache->clean([
			Cache::TAGS => ['navigation'],
		]);
	}
}
