<?php declare(strict_types = 1);

namespace Navigations\Model\Event;

use Core\Components\Navigation\DaoNavigationItem;
use Navigations\Model\Entities\Navigation;
use Symfony\Contracts\EventDispatcher\Event;

class RouteOutEvent extends Event
{
	/** @var Navigation|null */
	public $navigation;

	/** @var array */
	public $urlParams;

	/** @var string|null */
	public $url;

	/** @var bool */
	public $disableDefaultFilter = false;

	public function __construct(?DaoNavigationItem $navigation = null, array &$urlParams, ?string &$url = null)
	{
		$this->navigation = $navigation;
		$this->urlParams  = &$urlParams;
		$this->url        = &$url;
	}
}
