<?php declare(strict_types = 1);

namespace Navigations\Model\Providers;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\AdminModule\Components\NavigationForm;
use Nette\Utils\ArrayHash;

interface INavigationItem
{
	/**
	 * @return string
	 */
	public function getId();

	/**
	 * @return string
	 */
	public function getGroup();

	/**
	 * @return string
	 */
	public function getGroupTitle();

	/**
	 * @return string
	 */
	public function getTitle();

	/**
	 * @param BaseForm $form
	 *
	 * @return BaseContainer
	 */
	public function getFormContainer(BaseForm $form);

	public function formSuccess(BaseForm $form, ArrayHash $values);

	public function getTemplateFile(): ?string;

	public function navigationFormCustomHandle(NavigationForm $component, array $data = []): void;

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	/**
	 * @param $presenter
	 * @param $action
	 *
	 * @return bool
	 */
	public function presenterActionCheck($presenter, $action);

	/**
	 * @return string
	 */
	public function getPresenter();

	/**
	 * @return string
	 */
	public function getAction();

	/**
	 * @param       $componentParams
	 * @param array $urlParams
	 *
	 * @return mixed
	 */
	public function routerIn($componentParams, $urlParams = []);

	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string;

	public function getComponentChild(string $lang, $navigation = null, $siteMapData = false);
}
