<?php declare(strict_types = 1);

namespace Navigations\Model;

use Core\Model\Helpers\Strings;
use Core\Model\Parameters;
use Core\Model\Router\RouteHelper;
use Core\Model\Router\Route;
use Core\Model\Router\RouteList;

class RouterFrontFactory
{
	/** @var Navigations */
	public $navigationsService;

	/** @var RouteHelper */
	protected $routerHelper;

	public function __construct(Navigations $navigations, RouteHelper $routeHelper)
	{
		$this->navigationsService = $navigations;
		$this->routerHelper       = $routeHelper;
	}

	public function createRouter()
	{
		$router = new RouteList;

		$router[] = $this->routerHelper->createRoute('/<path .*>', [
			null => [
				Route::FILTER_IN  => function($params) {
					if (!isset($params['path']))
						return null;

					if (isset($params['locale']) && $params['locale'] === 'cz')
						$params['locale'] = 'cs';

					$in = $this->navigationsService->getIdByUrl($params);

					if ($in) {
						if (is_array($params))
							$params = $params + $in;
						unset($params['path']);

						return $params;
					}

					return null;
				},
				Route::FILTER_OUT => function($params) {
					$out = $this->navigationsService->getUrlById($params);

					if ($out) {
						$params['path'] = ltrim($out, '/');
					} else {
						return null;
					}

					unset($params['id']);
					unset($params['locale']);
					unset($params['action']);
					unset($params['presenter']);
					unset($params['activeNavigation']);

					// kvuli eshop filtru
					if ((isset($params['productsFilter-filter']['f'][''])
							|| empty($params['productsFilter-filter'])
							|| $params['productsFilter-filter'] === null)
						&& isset($params['do']) && Strings::startsWith((string) $params['do'], 'productsFilter')) {
						unset($params['do']);
					}

					return $params;
				},
			],
		]);

		$router[] = $this->routerHelper->createRoute('/[<locale [a-z]{2}>/]', [
			null => [
				Route::FILTER_IN  => function($params) {
					if (isset($params['locale']) && $params['locale'] === 'cz')
						$params['locale'] = 'cs';

					unset($params['activeNavigation']);
					unset($params['id']);

					$hp = $this->navigationsService->getHomepageForRouter($params['locale']);

					if ($hp)
						return $params + $hp;
					else
						return $params;
				},
				Route::FILTER_OUT => function($params) {
					unset($params['id']);
					unset($params['action']);
					unset($params['presenter']);
					unset($params['activeNavigation']);

					return $params;
				},
			],
		]);

		return $router;
	}
}
