<?php declare(strict_types = 1);

namespace Navigations\DI;

use Core\DI\CompilerExtension;
use Nette\Localization\ITranslator;
use Navigations\Model\Navigations;
use Navigations\Model\Providers\INavigationItem;
use Navigations\Model\Templating\Macros\NavLink;
use Nette;

/**
 * Class NavigationsExtension
 * @package Navigations\DI
 */
class NavigationsExtension extends CompilerExtension
{
	/** @var array */
	protected $navigationItems = [];

	public function loadConfiguration()
	{
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		Nette\DI\Compiler::loadDefinitions(
			$this->getContainerBuilder(),
			$this->loadFromFile(__DIR__ . '/services.neon')
		);
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Navigations' => 'Navigations\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();

		$builder->getDefinition('nette.latteFactory')
			->addSetup(NavLink::class . '::install(?->getCompiler(), ?)', ['@self',
				$builder->getDefinition('navigations.navigations')])
			->addSetup('addFilter', ['navLink', $builder->getDefinition('navigations.filters.navLink')]);

		$service = $builder->getDefinition('navigations.itemsCollector');
		$service->addSetup(new Nette\DI\Statement('$service->loadClasses(?)', [$builder->findByType(INavigationItem::class)]));

		foreach ($builder->findByType(INavigationItem::class) as $k => $service)
			$this->navigationItems[] = $k;
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init = $class->methods["initialize"];

		//TODO je lepší řešení? Translator je potřeba v navigaci
		$init->addBody('$translatorService = $this->getService(\'translation.translator\');');
		$init->addBody('$this->getService(\'navigations.navigations\')->translator = $translatorService;');

		foreach ($this->navigationItems as $item)
			$init->addBody('$this->getService(\'' . $item . '\')->setTranslator($translatorService);');
	}

}
