<?php declare(strict_types = 1);

namespace Navigations\Model\Templating\Macros;

use Latte;
use Latte\Compiler;
use Latte\MacroNode;
use Latte\Macros\MacroSet;
use Latte\PhpWriter;
use Navigations\Model\Navigations;
use Nette\Utils\Json;

// TODO odstranit
final class NavLink extends MacroSet
{
	/** @var Navigations */
	protected $navigationsService;

	public function __construct(Latte\Compiler $compiler, Navigations $navigations)
	{
		parent::__construct($compiler);
		$this->navigationsService = $navigations;
	}

	public static function install(Compiler $compiler, $navigations)
	{
		$self = new self($compiler, $navigations);
		$self->addMacro('navLink', [$self, 'macroNavLink']);
	}

	public function macroNavLink(MacroNode $node, PhpWriter $writer)
	{
		$str = '';
		$nav = $this->navigationsService->get((int) $node->args);

		if ($nav) {
			$link = $this->navigationsService->generateLink($nav);
			$str  = "echo '" . $link . "'";
		}

		return $writer->write($str);
	}
}