<?php declare(strict_types = 1);

namespace Navigations\AdminModule\Presenters;

use Core\Model\UI\Form\BaseForm;
use Navigations\AdminModule\Components\INavigationFormFactory;
use Navigations\AdminModule\Components\INavigationGroupFormFactory;
use Navigations\AdminModule\Components\INavigationsGridFactory;
use Navigations\AdminModule\Components\INavigationsGroupsGridFactory;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Entities\NavigationGroup;
use Nette\Http\IResponse;
use Nette\Utils\Html;

final class DefaultPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		$this['title']->setTitle($this->translator->translate('navigations.title.navigations'));
		$this->setHeader('navigations.title.navigations', 'fa fa-sitemap');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault()
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'navigations.menu.newItemNavigation',
				'link'  => 'Default:add',
				'ico'   => 'plus',
			], [
				'title' => 'navigations.menu.newNavigationGroup',
				'link'  => 'Default:addGroup',
				'ico'   => 'plus',
			],
		]]);
	}

	public function actionAdd()
	{
		$this->setTitle($this->translator->translate('navigations.title.newNavigation'));
		$this->setHeader('navigations.title.newNavigation', 'fa fa-sitemap');
	}

	public function actionAddGroup()
	{
		$this->setTitle($this->translator->translate('navigations.title.newNavigationGroup'));
		$this->setHeader('navigations.title.newNavigationGroup', 'fa fa-sitemap');
	}

	public function actionEdit($id)
	{
		$navigation = $this->em->getRepository(Navigation::class)->find($id);

		if (!$navigation)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('navigations.title.editNavigation'), $navigation->title);
		$this->setHeader('navigations.title.editNavigation', 'fa fa-sitemap');
	}

	public function actionEditGroup($id)
	{
		$navigationGroup = $this->em->getRepository(NavigationGroup::class)->find($id);

		if (!$navigationGroup)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('navigations.title.editNavigationGroup'), $navigationGroup->title);
		$this->setHeader('navigations.title.editNavigationGroup', 'fa fa-sitemap');
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentNavigationsGrid(INavigationsGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentNavigationForm(INavigationFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setNavigation($this->getParameter('id'));

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('edit', $form->getCustomData('navigationId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function(BaseForm $form) {
			$this->redirect('default');
		};
		$control['form']->onCancel[]              = function(BaseForm $form) {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentNavigationsGroupsGrid(INavigationsGroupsGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentNavigationGroupForm(INavigationGroupFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setNavigationGroup($this->getParameter('id'));

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('editGroup', $form->getCustomData('navigationGroupId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function(BaseForm $form) {
			$this->redirect('default');
		};
		$control['form']->onCancel[]              = function(BaseForm $form) {
			$this->redirect('default');
		};

		return $control;
	}
}