<?php declare(strict_types = 1);

namespace Navigations\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="navigations__navigation_group")
 * @ORM\Entity
 * @ORM\EntityListeners({"NavigationGroupListener"})
 */
class NavigationGroup
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255, nullable=false)
	 */
	public $title;

	/**
	 * @var string
	 * @ORM\Column(name="type", type="string", length=255, nullable=true)
	 */
	public $type;

	public function __construct($title)
	{
		$this->title = $title;
	}
}
